/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.sound.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import org.kc7bfi.jflac.metadata.StreamInfo;
import org.kc7bfi.jflac.sound.spi.FlacEncoding;

public class FlacAudioFormat
extends AudioFormat {
    public static final String KEY_FRAMESIZE_MIN = "framesize_min";
    public static final String KEY_FRAMESIZE_MAX = "framesize_max";
    public static final String KEY_BLOCKSIZE_MIN = "blocksize_min";
    public static final String KEY_BLOCKSIZE_MAX = "blocksize_max";
    private HashMap props = new HashMap();

    public FlacAudioFormat(StreamInfo streamInfo) {
        super(FlacEncoding.FLAC, streamInfo.getSampleRate(), streamInfo.getBitsPerSample(), streamInfo.getChannels(), -1, -1.0f, false);
        this.props.put(KEY_FRAMESIZE_MIN, new Integer(streamInfo.getMinFrameSize()));
        this.props.put(KEY_FRAMESIZE_MAX, new Integer(streamInfo.getMaxFrameSize()));
        this.props.put(KEY_BLOCKSIZE_MIN, new Integer(streamInfo.getMinBlockSize()));
        this.props.put(KEY_BLOCKSIZE_MAX, new Integer(streamInfo.getMaxBlockSize()));
    }

    public Map properties() {
        HashMap ret = this.props == null ? new HashMap(0) : (HashMap)this.props.clone();
        return Collections.unmodifiableMap(ret);
    }

    public Object getProperty(String key) {
        if (this.props == null) {
            return null;
        }
        return this.props.get(key);
    }
}

