/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac;

public class FixedPredictor {
    private static final double M_LN2 = 0.6931471805599453;

    public static int computeBestPredictor(int[] data, int dataLen, double[] residualBitsPerSample) {
        int lastError0 = data[-1];
        int lastError1 = data[-1] - data[-2];
        int lastError2 = lastError1 - (data[-2] - data[-3]);
        int lastError3 = lastError2 - (data[-2] - 2 * data[-3] + data[-4]);
        int totalError0 = 0;
        int totalError1 = 0;
        int totalError2 = 0;
        int totalError3 = 0;
        int totalError4 = 0;
        for (int i = 0; i < dataLen; ++i) {
            int error = data[i];
            totalError0 += Math.abs(error);
            int save = error;
            totalError1 += Math.abs(error -= lastError0);
            lastError0 = save;
            save = error;
            totalError2 += Math.abs(error -= lastError1);
            lastError1 = save;
            save = error;
            totalError3 += Math.abs(error -= lastError2);
            lastError2 = save;
            save = error;
            totalError4 += Math.abs(error -= lastError3);
            lastError3 = save;
        }
        int order = totalError0 < Math.min(Math.min(Math.min(totalError1, totalError2), totalError3), totalError4) ? 0 : (totalError1 < Math.min(Math.min(totalError2, totalError3), totalError4) ? 1 : (totalError2 < Math.min(totalError3, totalError4) ? 2 : (totalError3 < totalError4 ? 3 : 4)));
        residualBitsPerSample[0] = totalError0 > 0 ? Math.log(0.6931471805599453 * (double)totalError0 / (double)dataLen) / 0.6931471805599453 : 0.0;
        residualBitsPerSample[1] = totalError1 > 0 ? Math.log(0.6931471805599453 * (double)totalError1 / (double)dataLen) / 0.6931471805599453 : 0.0;
        residualBitsPerSample[2] = totalError2 > 0 ? Math.log(0.6931471805599453 * (double)totalError2 / (double)dataLen) / 0.6931471805599453 : 0.0;
        residualBitsPerSample[3] = totalError3 > 0 ? Math.log(0.6931471805599453 * (double)totalError3 / (double)dataLen) / 0.6931471805599453 : 0.0;
        residualBitsPerSample[4] = totalError4 > 0 ? Math.log(0.6931471805599453 * (double)totalError4 / (double)dataLen) / 0.6931471805599453 : 0.0;
        return order;
    }

    public static int computeBestPredictorWide(int[] data, int dataLen, double[] residualBitsPerSample) {
        int lastError0 = data[-1];
        int lastError1 = data[-1] - data[-2];
        int lastError2 = lastError1 - (data[-2] - data[-3]);
        int lastError3 = lastError2 - (data[-2] - 2 * data[-3] + data[-4]);
        long totalError0 = 0L;
        long totalError1 = 0L;
        long totalError2 = 0L;
        long totalError3 = 0L;
        long totalError4 = 0L;
        for (int i = 0; i < dataLen; ++i) {
            int error = data[i];
            totalError0 += (long)Math.abs(error);
            int save = error;
            totalError1 += (long)Math.abs(error -= lastError0);
            lastError0 = save;
            save = error;
            totalError2 += (long)Math.abs(error -= lastError1);
            lastError1 = save;
            save = error;
            totalError3 += (long)Math.abs(error -= lastError2);
            lastError2 = save;
            save = error;
            totalError4 += (long)Math.abs(error -= lastError3);
            lastError3 = save;
        }
        int order = totalError0 < Math.min(Math.min(Math.min(totalError1, totalError2), totalError3), totalError4) ? 0 : (totalError1 < Math.min(Math.min(totalError2, totalError3), totalError4) ? 1 : (totalError2 < Math.min(totalError3, totalError4) ? 2 : (totalError3 < totalError4 ? 3 : 4)));
        residualBitsPerSample[0] = totalError0 > 0L ? Math.log(0.6931471805599453 * (double)totalError0 / (double)dataLen) / 0.6931471805599453 : 0.0;
        residualBitsPerSample[1] = totalError1 > 0L ? Math.log(0.6931471805599453 * (double)totalError1 / (double)dataLen) / 0.6931471805599453 : 0.0;
        residualBitsPerSample[2] = totalError2 > 0L ? Math.log(0.6931471805599453 * (double)totalError2 / (double)dataLen) / 0.6931471805599453 : 0.0;
        residualBitsPerSample[3] = totalError3 > 0L ? Math.log(0.6931471805599453 * (double)totalError3 / (double)dataLen) / 0.6931471805599453 : 0.0;
        residualBitsPerSample[4] = totalError4 > 0L ? Math.log(0.6931471805599453 * (double)totalError4 / (double)dataLen) / 0.6931471805599453 : 0.0;
        return order;
    }

    public static void computeResidual(int[] data, int dataLen, int order, int[] residual) {
        int idataLen = dataLen;
        switch (order) {
            case 0: {
                for (int i = 0; i < idataLen; ++i) {
                    residual[i] = data[i];
                }
                break;
            }
            case 1: {
                for (int i = 0; i < idataLen; ++i) {
                    residual[i] = data[i] - data[i - 1];
                }
                break;
            }
            case 2: {
                for (int i = 0; i < idataLen; ++i) {
                    residual[i] = data[i] - (data[i - 1] << 1) + data[i - 2];
                }
                break;
            }
            case 3: {
                for (int i = 0; i < idataLen; ++i) {
                    residual[i] = data[i] - ((data[i - 1] - data[i - 2] << 1) + (data[i - 1] - data[i - 2])) - data[i - 3];
                }
                break;
            }
            case 4: {
                for (int i = 0; i < idataLen; ++i) {
                    residual[i] = data[i] - (data[i - 1] + data[i - 3] << 2) + ((data[i - 2] << 2) + (data[i - 2] << 1)) + data[i - 4];
                }
                break;
            }
        }
    }

    public static void restoreSignal(int[] residual, int dataLen, int order, int[] data, int startAt) {
        int idataLen = dataLen;
        switch (order) {
            case 0: {
                for (int i = 0; i < idataLen; ++i) {
                    data[i + startAt] = residual[i];
                }
                break;
            }
            case 1: {
                for (int i = 0; i < idataLen; ++i) {
                    data[i + startAt] = residual[i] + data[i + startAt - 1];
                }
                break;
            }
            case 2: {
                for (int i = 0; i < idataLen; ++i) {
                    data[i + startAt] = residual[i] + (data[i + startAt - 1] << 1) - data[i + startAt - 2];
                }
                break;
            }
            case 3: {
                for (int i = 0; i < idataLen; ++i) {
                    data[i + startAt] = residual[i] + ((data[i + startAt - 1] - data[i + startAt - 2] << 1) + (data[i + startAt - 1] - data[i + startAt - 2])) + data[i + startAt - 3];
                }
                break;
            }
            case 4: {
                for (int i = 0; i < idataLen; ++i) {
                    data[i + startAt] = residual[i] + (data[i + startAt - 1] + data[i + startAt - 3] << 2) - ((data[i + startAt - 2] << 2) + (data[i + startAt - 2] << 1)) - data[i + startAt - 4];
                }
                break;
            }
        }
    }
}

