/*
 * Decompiled with CFR 0.152.
 */
package org.highc.util.gadget.ranges;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

class RangeSliderTooltip
extends JPanel {
    protected JComponent _component;
    protected JToolTip _tooltip;
    private static RangeSliderTooltip a;

    public static RangeSliderTooltip GetInstance() {
        if (a == null) {
            a = new RangeSliderTooltip();
        }
        return a;
    }

    protected RangeSliderTooltip() {
        this.setLayout(new BorderLayout());
        this.setDoubleBuffered(true);
        this.setOpaque(true);
    }

    public JComponent getComponent() {
        return this._component;
    }

    public void setComponent(JComponent jComponent) {
        if (this._component == jComponent) {
            return;
        }
        this._component = jComponent;
        if (this._tooltip != null) {
            this.remove(this._tooltip);
            this._tooltip = null;
        }
        if (this._component != null) {
            this._tooltip = this._component.createToolTip();
            this._tooltip.setComponent(this._component);
            this.add((Component)this._tooltip, "Center");
        }
    }

    public void setText(String string) {
        if (this._tooltip != null) {
            this._tooltip.setTipText(string);
            this.setSize(this._tooltip.getPreferredSize());
        }
    }

    public JToolTip getToolTip() {
        return this._tooltip;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void showTip(int n2, int n3) {
        this.hideTip();
        Point point = new Point(n2, n3);
        if (this._component.getRootPane() == null) {
            return;
        }
        point = SwingUtilities.convertPoint(this._component, point, this._component.getRootPane().getLayeredPane());
        this.setLocation(point.x, point.y);
        this._component.getRootPane().getLayeredPane().add(this, JLayeredPane.POPUP_LAYER, 0);
    }

    public void hideTip() {
        Container container = this.getParent();
        Rectangle rectangle = this.getBounds();
        if (container != null) {
            container.remove(this);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

