/*
 * Decompiled with CFR 0.152.
 */
package org.highc.upic.app.panes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import org.highc.upic.app.panes.ScaleEditor;
import org.highc.upic.app.panes.c;
import org.highc.upic.app.s;
import org.highc.upic.app.view.ContextProviderVisualization;
import org.highc.upic.app.view.Scale;
import org.highc.upic.app.view.TimeScale;
import org.highc.util.m;

public class TimeScaleEditor
extends ScaleEditor {
    private static ResourceBundle e = m.a(TimeScaleEditor.class);
    private JFormattedTextField f;
    private JFormattedTextField g;
    private JFormattedTextField h;
    private JCheckBox i;
    private JButton j;

    public TimeScaleEditor(s s2) {
        super(s2, e.getString("Time Scales"), "timeScales");
    }

    @Override
    protected void setScaleName(ContextProviderVisualization contextProviderVisualization, String string) {
        contextProviderVisualization.getScoreGrid().setTimeScaleName(string);
    }

    @Override
    protected String getScaleName(ContextProviderVisualization contextProviderVisualization) {
        return contextProviderVisualization.getScoreGrid().getTimeScaleName();
    }

    @Override
    protected void createEditLabels(Box box, Dimension dimension, Dimension serializable) {
        serializable = new JLabel(e.getString("beats/minute:"));
        ((JComponent)serializable).setPreferredSize(dimension);
        box.add((Component)serializable);
        serializable = new JLabel(e.getString("beats/bar:"));
        ((JComponent)serializable).setPreferredSize(dimension);
        box.add((Component)serializable);
        serializable = new JLabel(e.getString("bars grouped by:"));
        ((JComponent)serializable).setPreferredSize(dimension);
        box.add((Component)serializable);
        serializable = new JLabel(e.getString("group color:"));
        ((JComponent)serializable).setPreferredSize(dimension);
        box.add((Component)serializable);
    }

    @Override
    protected void createEditPane(Box box, Dimension dimension, Dimension dimension2) {
        this.f = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.f.addActionListener(this);
        this.f.setPreferredSize(dimension);
        box.add(this.f);
        this.g = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.g.addActionListener(this);
        this.g.setPreferredSize(dimension);
        box.add(this.g);
        this.h = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.h.addActionListener(this);
        this.h.setPreferredSize(dimension);
        box.add(this.h);
        this.j = new c(this, "");
        this.j.addActionListener(this);
        this.j.setPreferredSize(dimension);
        this.j.setMinimumSize(dimension);
        box.add(this.j);
        this.i = new JCheckBox(e.getString("Start at 0"));
        this.i.setPreferredSize(dimension);
        this.i.setMinimumSize(dimension);
        box.add(this.i);
        this.i.addActionListener(this);
    }

    @Override
    protected void refreshEditPane(Scale scale) {
        boolean bl = this.a.b(this.c.getText(), this.b) != null;
        scale = (TimeScale)scale;
        this.f.removeActionListener(this);
        this.g.removeActionListener(this);
        this.h.removeActionListener(this);
        this.i.removeActionListener(this);
        this.f.setEnabled(bl);
        this.g.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        if (scale == null) {
            this.f.setValue(new Float(60.0f));
            this.g.setValue(new Integer(10));
            this.h.setValue(new Integer(6));
        } else {
            this.f.setValue(new Float(((TimeScale)scale).getBeatsPerMinute()));
            this.g.setValue(new Integer(((TimeScale)scale).getBeatsPerBar()));
            this.h.setValue(new Integer(((TimeScale)scale).getGroupBars()));
            this.j.setForeground(((TimeScale)scale).getGroupColor());
            this.i.setSelected(((TimeScale)scale).isStartAt0());
        }
        this.f.addActionListener(this);
        this.g.addActionListener(this);
        this.h.addActionListener(this);
        this.i.addActionListener(this);
    }

    @Override
    protected Scale updateFromEditPane(String object, Scale object2) {
        object = object2 == null ? new TimeScale((String)object, 60.0f, 6, 10) : (TimeScale)object2;
        try {
            this.f.commitEdit();
            this.g.commitEdit();
            this.h.commitEdit();
            ((TimeScale)object).setBeatsPerMinute(((Number)this.f.getValue()).floatValue());
            ((TimeScale)object).setBeatsPerBar(((Number)this.g.getValue()).intValue());
            ((TimeScale)object).setGroupBars(((Number)this.h.getValue()).intValue());
            object2 = new Color(this.j.getForeground().getRGB());
            ((TimeScale)object).setGroupColor((Color)object2);
            ((TimeScale)object).setStartAt0(this.i.isSelected());
        }
        catch (Exception exception) {}
        return object;
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        if (serializable.getSource() == this.j) {
            serializable = JColorChooser.showDialog(this.a.m(), e.getString("Choose a color for the group separators"), this.j.getForeground());
            if (serializable != null) {
                this.j.setForeground((Color)serializable);
            }
            this.j.repaint();
            this.d.setEnabled(true);
            return;
        }
        super.actionPerformed((ActionEvent)serializable);
    }
}

