/*
 * Decompiled with CFR 0.152.
 */
package org.highc.upic.app.panes;

import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.highc.upic.app.panes.ScaleEditor;
import org.highc.upic.app.s;
import org.highc.upic.app.view.ContextProviderVisualization;
import org.highc.upic.app.view.PitchScale;
import org.highc.upic.app.view.Scale;
import org.highc.util.m;

public class PitchScaleEditor
extends ScaleEditor
implements DocumentListener {
    private static ResourceBundle e = m.a(PitchScaleEditor.class);
    private JFormattedTextField f;
    private JTextArea g;

    public PitchScaleEditor(s s2) {
        super(s2, e.getString("Pitch Scales"), "pitchScales");
    }

    @Override
    protected void setScaleName(ContextProviderVisualization contextProviderVisualization, String string) {
        contextProviderVisualization.getScoreGrid().setPitchScaleName(string);
    }

    @Override
    protected String getScaleName(ContextProviderVisualization contextProviderVisualization) {
        return contextProviderVisualization.getScoreGrid().getPitchScaleName();
    }

    @Override
    protected void createEditLabels(Box box, Dimension dimension, Dimension serializable) {
        serializable = new JLabel(e.getString("reference (Hz):"));
        ((JComponent)serializable).setPreferredSize(dimension);
        box.add((Component)serializable);
        serializable = new JLabel(e.getString("definition:"));
        ((JComponent)serializable).setPreferredSize(dimension);
        box.add((Component)serializable);
    }

    @Override
    protected void createEditPane(Box box, Dimension dimension, Dimension dimension2) {
        this.f = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.f.addActionListener(this);
        this.f.setPreferredSize(dimension);
        box.add(this.f);
        this.g = new JTextArea();
        if (this.g.getDocument() != null) {
            this.g.getDocument().addDocumentListener(this);
        }
        JScrollPane jScrollPane = new JScrollPane(this.g);
        dimension = new Dimension(dimension.width, dimension.height << 2);
        new Dimension(dimension2.width, dimension2.height * 10);
        jScrollPane.setPreferredSize(dimension);
        box.add(jScrollPane);
    }

    @Override
    protected void refreshEditPane(Scale scale) {
        boolean bl = this.a.b(this.c.getText(), this.b) != null;
        scale = (PitchScale)scale;
        if (this.g.getDocument() != null) {
            this.g.getDocument().removeDocumentListener(this);
        }
        this.f.removeActionListener(this);
        this.g.setEnabled(bl);
        this.f.setEnabled(bl);
        if (scale == null) {
            this.g.setText("");
            this.f.setText("440");
        } else {
            this.f.setValue(new Float(((PitchScale)scale).getReference()));
            this.g.setText(((PitchScale)scale).getDefinition());
        }
        this.f.addActionListener(this);
        if (this.g.getDocument() != null) {
            this.g.getDocument().addDocumentListener(this);
        }
    }

    @Override
    protected Scale updateFromEditPane(String object, Scale scale) {
        object = scale == null ? new PitchScale((String)object, 440.0f) : (PitchScale)scale;
        try {
            this.f.commitEdit();
        }
        catch (ParseException parseException) {}
        ((PitchScale)object).setReference(((Number)this.f.getValue()).floatValue());
        ((PitchScale)object).setDefinition(this.g.getText());
        return object;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.d.setEnabled(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.d.setEnabled(true);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.d.setEnabled(true);
    }
}

